<?php

namespace App\Filament\Resources\Abastecimentos;

use App\Filament\Resources\Abastecimentos\Pages\CreateAbastecimento;
use App\Filament\Resources\Abastecimentos\Pages\EditAbastecimento;
use App\Filament\Resources\Abastecimentos\Pages\ListAbastecimentos;
use App\Filament\Resources\Abastecimentos\Pages\ViewAbastecimento;
use App\Filament\Resources\Abastecimentos\Schemas\AbastecimentoForm;
use App\Filament\Resources\Abastecimentos\Schemas\AbastecimentoInfolist;
use App\Filament\Resources\Abastecimentos\Tables\AbastecimentosTable;
use App\Models\Abastecimento;
use BackedEnum;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use UnitEnum;


class AbastecimentoResource extends Resource
{
    use HasPageShield;
    

    protected static ?string $model = Abastecimento::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | UnitEnum | null $navigationGroup = 'Gestão de Frotas';

    protected static ?string $recordTitleAttribute = 'Abastecimentos';

        public static function getPermissionPrefixes(): array
    {
        return [
            'view',
            'view_any',
            'create',
            'update',
            'delete',
            'delete_any',
            'restore',
            'restore_any',
            'replicate',
            'reorder',
        ];
    }

    public static function form(Schema $schema): Schema
    {
        return AbastecimentoForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return AbastecimentoInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AbastecimentosTable::configure($table);
    }
    
    

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAbastecimentos::route('/'),
            'create' => CreateAbastecimento::route('/create'),
            'view' => ViewAbastecimento::route('/{record}'),
            'edit' => EditAbastecimento::route('/{record}/edit'),
        ];
    }

    //     public static function getEloquentQuery(): Builder
    // {
        // return parent::getEloquentQuery()
        //     ->join('drivers', 'abastecimentos.id_motorista', '=', 'drivers.id')
        //     ->join('funcionarios', 'drivers.funcionario_id', '=', 'funcionarios.id')
        //     ->join('viaturas', 'abastecimentos.id_veiculo','=', 'viaturas.id')
        //     ->select('abastecimentos.*', 'funcionarios.nome as nome_driver', 'viaturas.codigo_viatura as carro'); // Adiciona o nome como campo virtual

    //                 public static function getEloquentQuery(): Builder
    // {
    //     return parent::getEloquentQuery()
    //     ->with(['veiculo', 'motorista.funcionario']);
    // }
    // }
}
