<?php

namespace App\Filament\Resources\Abastecimentos\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;

class AbastecimentoForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('motorista_id')
                ->label('Motorista')
                ->relationship('motorista.funcionario', 'nome')
                ->required()
                ->native(false),
                
                Select::make('veiculo_id')
                ->label('veiculo')
                ->relationship('veiculo', 'codigo_viatura')
                ->required()
                ->native(false),
                TextInput::make('kilometragem')
                    ->required()
                    ->numeric(),
                TextInput::make('quantidade')
                    ->required()
                    ->numeric(),
                TextInput::make('valor')
                    ->required()
                    ->numeric(),
                TextInput::make('posto_abstecimento')
                    ->required(),
            ]);
    }
}
