<?php

namespace App\Filament\Resources\CentroCustos\Schemas;

use App\Models\CentroCusto;
use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class CentroCustoInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('codigo'),
                TextEntry::make('nome'),
                TextEntry::make('descricao')
                    ->placeholder('-'),
                TextEntry::make('tipo'),
                IconEntry::make('ativo')
                    ->boolean(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (CentroCusto $record): bool => $record->trashed()),
            ]);
    }
}
