<?php

namespace App\Filament\Resources\ContaPagars;

use App\Filament\Resources\ContaPagars\Pages\CreateContaPagar;
use App\Filament\Resources\ContaPagars\Pages\EditContaPagar;
use App\Filament\Resources\ContaPagars\Pages\ListContaPagars;
use App\Filament\Resources\ContaPagars\Pages\ViewContaPagar;
use App\Filament\Resources\ContaPagars\Schemas\ContaPagarForm;
use App\Filament\Resources\ContaPagars\Schemas\ContaPagarInfolist;
use App\Filament\Resources\ContaPagars\Tables\ContaPagarsTable;
use App\Models\ContaPagar;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ContaPagarResource extends Resource
{
    protected static ?string $model = ContaPagar::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | \UnitEnum | null $navigationGroup = 'Contabilidade';

    protected static ?string $recordTitleAttribute = 'Conta_pagar';

    public static function form(Schema $schema): Schema
    {
        return ContaPagarForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ContaPagarInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ContaPagarsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListContaPagars::route('/'),
            'create' => CreateContaPagar::route('/create'),
            'view' => ViewContaPagar::route('/{record}'),
            'edit' => EditContaPagar::route('/{record}/edit'),
        ];
    }
}
