<?php

namespace App\Filament\Resources\ContaRecebers\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use function Laravel\Prompts\select;

class ContaReceberForm
{
    
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('cliente_id')
                    ->relationship('cliente', 'nome'),
                Select::make('frete_id')
                ->relationship('frete','numero_frete'),
                TextInput::make('outros_devedores'),
                TextInput::make('descricao')
                    ->required(),
                TextInput::make('valor')
                    ->required()
                    ->numeric(),
                DatePicker::make('data_emissao')
                    ->required(),
                DatePicker::make('data_vencimento')
                    ->required(),
                DatePicker::make('data_pagamento'),
                TextInput::make('valor_pago')
                    ->numeric(),
                Select::make('status')
                    ->options(['pendente' => 'Pendente', 'pago' => 'Pago',  'pago parcialmente' => 'Pago Parcialmente', 'cancelado' => 'Cancelado'])
                    ->required(),
                TextInput::make('numero_lancamento'),
                Textarea::make('observacoes')
                    ->columnSpanFull(),


            ]);

            
    }
}
