<?php

namespace App\Filament\Resources\ContaRecebers\Schemas;

use App\Models\ContaReceber;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ContaReceberInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('cliente.nome')
                ->label('Cliente')
                ->placeholder(placeholder: '-')
                    ->numeric(),
                TextEntry::make('frete.numero_frete')
                    ->numeric()
                    ->placeholder(placeholder: '-'),
                TextEntry::make('outros_devedores')
                ->placeholder(placeholder: '-'),
                TextEntry::make('descricao'),
                TextEntry::make('valor')
                    ->numeric(),
                TextEntry::make('data_emissao')
                    ->date(),
                TextEntry::make('data_vencimento')
                    ->date(),
                TextEntry::make('data_pagamento')
                ->placeholder(placeholder: '-')
                    ->date()
                    ->placeholder('-'),
                TextEntry::make('valor_pago')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('status'),
                TextEntry::make('numero_lancamento'),
                TextEntry::make('observacoes')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (ContaReceber $record): bool => $record->trashed()),
            ]);
    }
}
