<?php

namespace App\Filament\Resources\Contas\Schemas;

use App\Models\Conta;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ContaInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('banco'),
                TextEntry::make('numero')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('tipo'),
                TextEntry::make('nib')
                    ->placeholder('-'),
                TextEntry::make('nuib')
                    ->placeholder('-'),
                TextEntry::make('titular'),
                TextEntry::make('moeda'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Conta $record): bool => $record->trashed()),
            ]);
    }
}
