<?php

namespace App\Filament\Resources\Drivers\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;

class DriverForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('codigo'),
                TextInput::make('nome')
                    ->required(),
                TextInput::make('bi')
                    ->required(),
                DatePicker::make('data_nascimento')
                    ->required(),
                TextInput::make('local_nascimento')
                    ->required(), 
                TextInput::make('nacionalidade')
                    ->required(),                  
                TextInput::make('telefone')
                    ->tel(),
                TextInput::make('email')
                    ->label('Email address')
                    ->email(),
                TextInput::make('endereco'),
            
                TextInput::make('carta_conducao')
                    ->required(),
                DatePicker::make('validade'),
            ]);
    }
}
