<?php

namespace App\Filament\Resources\Fornecedors\Schemas;

use App\Models\Fornecedor;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class FornecedorInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('nome'),
                TextEntry::make('sigla'),
                TextEntry::make('nuit'),
                TextEntry::make('telefone'),
                TextEntry::make('email')
                    ->label('Email address'),
                TextEntry::make('endereco'),
                TextEntry::make('cidade'),
                TextEntry::make('provincia'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Fornecedor $record): bool => $record->trashed()),
            ]);
    }
}
