<?php

namespace App\Filament\Resources\Fretes\Schemas;

use App\Models\Frete;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class FreteInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('viagem_id')
                    ->numeric(),
                TextEntry::make('valor_frete')
                    ->numeric(),
                TextEntry::make('valor_adiantamento')
                    ->numeric(),
                TextEntry::make('valor_seguro')
                    ->numeric(),
                TextEntry::make('valor_portagem')
                    ->numeric(),
                TextEntry::make('valor_outros')
                    ->numeric(),
                TextEntry::make('valor_liquido')
                    ->numeric(),
                TextEntry::make('forma_pagamento'),
                TextEntry::make('parcelas')
                    ->numeric(),
                TextEntry::make('data_vencimento')
                    ->date(),
                TextEntry::make('status_pagamento')
                    ->badge(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Frete $record): bool => $record->trashed()),
            ]);
    }
}
