<?php

namespace App\Filament\Resources\Fretes\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class FretesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('numero_frete')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('numero_frete')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_frete')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_adiantamento')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_seguro')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_portagem')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_outros')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('valor_liquido')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('forma_pagamento')
                    ->searchable(),
                TextColumn::make('parcelas')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('data_vencimento')
                    ->date()
                    ->sortable(),
                TextColumn::make('status_pagamento')
                    ->badge(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
