<?php

namespace App\Filament\Resources\LancamentoContabils\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class LancamentoContabilForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('tipo')
                    ->required()
                    ->options(['entrada'=>'Entrada', 'saida'=>'Saida'])
                    ->live() 
                    ->afterStateUpdated(function ($state, callable $set) {
                    // Resetar campos quando mudar o tipo
                    if ($state === 'entrada') {
                        $set('conta_saida', null);
                        $set('valor_saida', null);
                    } else {
                        $set('conta_entrada', null);
                        $set('valor_entrada', null);
                    }
                }),
                Select::make('conta_id')
                ->relationship('conta', 'banco')
                    ->required(),
                Select::make('cliente_id')
                ->relationship('cliente', 'nome')
                ->hidden(fn ($get) => $get('tipo') !== 'saida'),
                Select::make('fornecedor_id')
                ->relationship('fornecedor', 'nome')
                ->hidden(fn ($get) => $get('tipo') !== 'entrada'),
                Select::make('frete_id')
                ->relationship('frete', 'numero_frete'),
                Select::make('factura_id')
                ->relationship('factura', 'numero')
                ->hidden(fn ($get) => $get('tipo') !== 'saida'),
                Select::make('conta_receber_id')
                ->relationship('conta_receber', 'numero')
                ->hidden(fn ($get) => $get('tipo') !== 'saida'),
                TextInput::make('descricao')
                    ->required(),
                TextInput::make('valor')
                    ->required()
                    ->numeric(),
                DatePicker::make('data_emissao')
                    ->required(),
                DatePicker::make('data_pagamento')
                    ->required(),
                Select::make('centro_custo_id')
                ->Relationship('centro_custo', 'nome')
                ->hidden(fn ($get) => $get('tipo') !== 'saida'),
                Select::make('forma_pagamento')
                ->options([
                    'cash'=>'Cash',
                    'transferencia'=> 'Transferencia',
                    'deposito bancario'=>'Deposito bancario',
                    'cartao_credito'=>'Cartao de Credito',
                    'cartao_debito'=>'Cartao de debito',
                    'cheque'=>'Cheque'
                ]),
                TextInput::make('observacoes'),
                

            ]);
    }
}
