<?php

namespace App\Filament\Resources\Manutencaos\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class ManutencaoForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('veiculo_id')
                    ->required()
                    ->numeric(),
                DatePicker::make('data')
                    ->required(),
                TextInput::make('km_atual')
                    ->required()
                    ->numeric(),
                TextInput::make('tipo')
                    ->required(),
                TextInput::make('servico')
                    ->required(),
                Textarea::make('descricao')
                    ->columnSpanFull(),
                TextInput::make('valor')
                    ->required()
                    ->numeric(),
                TextInput::make('fornecedor_id')
                    ->numeric(),
                TextInput::make('numero_nota'),
                TextInput::make('status')
                    ->required(),
                DatePicker::make('proxima_manutencao_km'),
                DatePicker::make('proxima_manutencao_data'),
            ]);
    }
}
