<?php

namespace App\Filament\Resources\Manutencaos\Schemas;

use App\Models\Manutencao;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ManutencaoInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('veiculo_id')
                    ->numeric(),
                TextEntry::make('data')
                    ->date(),
                TextEntry::make('km_atual')
                    ->numeric(),
                TextEntry::make('tipo'),
                TextEntry::make('servico'),
                TextEntry::make('descricao')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('valor')
                    ->numeric(),
                TextEntry::make('fornecedor_id')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('numero_nota')
                    ->placeholder('-'),
                TextEntry::make('status'),
                TextEntry::make('proxima_manutencao_km')
                    ->date()
                    ->placeholder('-'),
                TextEntry::make('proxima_manutencao_data')
                    ->date()
                    ->placeholder('-'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Manutencao $record): bool => $record->trashed()),
            ]);
    }
}
