<?php

namespace App\Filament\Resources\Viagems\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Schemas\Schema;

class ViagemForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('origem')
                    ->required(),
                TextInput::make('destino')
                    ->required(),
                    
                Select::make('motorista_id')
                ->label('Motorista')
                ->relationship('motorista', 'codigo')
                ->required()
                ->native(false),
                
                Select::make('veiculo_id')
                ->label('veiculo')
                ->relationship('veiculo', 'codigo_viatura')
                ->required()
                ->native(false),

                Select::make('status')
                ->label('Status')
                ->options(['Pendente' => 'Pendente',
                                    'Em preparação' => 'Em preparacao',
                                    'Em curso' => 'Em curso',
                                    'Parada operacional' => 'Parada operacional',
                                    'Parada por emergência' => 'Parada por emergência',
                                    'Atrasada' => 'Atrasada',
                                    'Concluída' => 'Concluída',
                                    'Em manutenção' => 'Em manutenção'
                                    ])
                ->required()
                ->native(false),
                

                DatePicker::make('data_partida')
                    ->required(),
                DatePicker::make('d_chegada_prevista'),
                DatePicker::make('d_chegada_real'),
                TextInput::make('distancia')
                    ->required()
                    ->numeric(),
                TextInput::make('kilometragem_inicial')
                    ->required()
                    ->numeric(),
                TextInput::make('kilometragem_final')
                    ->required()
                    ->numeric(),
                
            ]);
    }
}
