<?php

namespace App\Filament\Resources\Viagems\Schemas;

use App\Models\Viagem;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ViagemInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('origem'),
                TextEntry::make('destino'),
                TextEntry::make('data_partida')
                    ->date(),
                TextEntry::make('d_chegada_prevista')
                    ->date(),
                TextEntry::make('d_chegada_real')
                    ->date(),
                TextEntry::make('distancia')
                    ->numeric(),
                TextEntry::make('kilometragem_inicial')
                    ->numeric(),
                TextEntry::make('kilometragem_final')
                    ->numeric(),
                TextEntry::make('motorista.funcionario.nome'),
                TextEntry::make('veiculo.matricula')
                    ->numeric(),
                TextEntry::make('status'),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (Viagem $record): bool => $record->trashed()),
            ]);
    }
}
