<?php

namespace App\Filament\Resources\Viagems\Tables;

use App\Models\Funcionario;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ViagemsTable
{
    public static function configure(Table $table): Table
    {
        return $table

             ->columns([
                TextColumn::make('origem')
                    ->searchable(),
                TextColumn::make('destino')
                    ->searchable(),
                TextColumn::make('data_partida')
                    ->date()
                    ->sortable(),
                TextColumn::make('d_chegada_prevista')
                    ->date()
                    ->sortable(),
                TextColumn::make('d_chegada_real')
                    ->date()
                    ->sortable(),
                TextColumn::make('distancia')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('kilometragem_inicial')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('kilometragem_final')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('motorista.funcionario.nome')
                    ->sortable(),
                TextColumn::make('veiculo.matricula')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('status')
                    ->sortable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
