<?php

namespace App\Filament\Resources\Viagems;

use App\Filament\Resources\Viagems\Pages\CreateViagem;
use App\Filament\Resources\Viagems\Pages\EditViagem;
use App\Filament\Resources\Viagems\Pages\ListViagems;
use App\Filament\Resources\Viagems\Pages\ViewViagem;
use App\Filament\Resources\Viagems\Schemas\ViagemForm;
use App\Filament\Resources\Viagems\Schemas\ViagemInfolist;
use App\Filament\Resources\Viagems\Tables\ViagemsTable;
use App\Models\Viagem;
use BackedEnum;
// use Filament\Forms\Components\Builder;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use UnitEnum;

class ViagemResource extends Resource
{
    protected static ?string $model = Viagem::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string | UnitEnum | null $navigationGroup = 'Gestão de Frotas';

    protected static ?string $recordTitleAttribute = 'Viagem';

    public static function form(Schema $schema): Schema
    {
        return ViagemForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ViagemInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ViagemsTable::configure($table);
    }

    // public static function getEloquentQuery(): Builder
    // {
    //     return parent::getEloquentQuery()
    //         ->join('drivers', 'viagems.id_motorista', '=', 'drivers.id')
    //         ->join('funcionarios', 'drivers.funcionario_id', '=', 'funcionarios.id')
    //         ->select('viagems.*', 'funcionarios.nome as nome_driver'); // Adiciona o nome como campo virtual
    // }

    


    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListViagems::route('/'),
            'create' => CreateViagem::route('/create'),
            'view' => ViewViagem::route('/{record}'),
            'edit' => EditViagem::route('/{record}/edit'),
        ];
    }
}
