<?php

namespace App\Livewire;

use App\Models\Conta;
use App\Models\LancamentoContabil;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class SaldosWidget extends StatsOverviewWidget
{
    protected function getStats(): array
    {
       $contas = Conta::all();
        $stats = [];
        $stats2=[];

        $saldoGeral=LancamentoContabil::sum(\DB::raw('CASE WHEN tipo = "credito" THEN valor ELSE -valor END'));

        foreach ($contas as $conta) {
            // Calcula o saldo somando todos os movimentos da conta
            // $saldo = Movimento::where('conta_id', $conta->id)
            //     ->sum('valor');
            
            // Ou se tiver crédito/débito separado
            $saldo = LancamentoContabil::where('conta_id', $conta->id)
                ->sum(\DB::raw('CASE WHEN tipo = "entrada" THEN valor ELSE -valor END'));

            $stats[] = Stat::make('Saldo geral', number_format($saldoGeral, 2, ',', '.') . ' MT')
                ->description($conta->tipo) // ou qualquer outro campo
                ->color($this->getColorBasedOnSaldo($saldo))
                ->icon($conta->banco === 'corrente' ? 'heroicon-o-banknotes' : 'heroicon-o-wallet')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => '$dispatch("open-modal", { id: "conta-details-' . $conta->id . '" })',
                ]);
        }

        $stats2[] = Stat::make('Saldo Geral', number_format($saldoGeral, 2, ',', '.') . ' MT')
                ->description('Entradas e Saidas') // ou qualquer outro campo
                ->color($this->getColorBasedOnSaldoGeral($saldoGeral))
                ->icon('heroicon-o-banknotes');


       
        return 
            $stats2
        
        ;
    }

    private function getColorBasedOnSaldo(float $saldo): string
    {
        return match (true) {
            $saldo > 0 => 'success',
            $saldo < 0 => 'danger',
            default => 'warning',
        };
    }

    private function getColorBasedOnSaldoGeral(float $saldoGeral): string
    {
        return match (true) {
            $saldoGeral > 0 => 'success',
            $saldoGeral < 0 => 'danger',
            default => 'warning',
        };
    }
}
