<?php

namespace App\Models;

use App\Filament\Resources\Fretes\Widgets\Frete;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Carga extends Model
{
    use HasFactory, SoftDeletes;
    
protected $fillable=[
    'producto_id',
'cliente_id',
'descricao',
'peso',
'volume',
'tipo',
'valor',

];

protected $casts = [
        'peso' => 'decimal:2',
        'volume' => 'decimal:2',
        'valor_unitario' => 'decimal:2',
        'quantidade_estoque' => 'decimal:2'
    ];

    // Relacionamento muitos-para-muitos com Frete
    public function fretes(): BelongsToMany
    {
        return $this->belongsToMany(Frete::class, 'frete_carga')
                    ->withPivot(['quantidade', 'valor_unitario', 'valor_total', 'status', 'observacao'])
                    ->withTimestamps();
    }


    public function producto()
      {
        return $this->belongsTo(Productos::class);
      }

      public function clientes()
      {
        return $this->belongsTo(Cliente::class);
      }
}
