<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContaPagar extends Model
{
    use HasFactory;
use SoftDeletes;
    protected $fillable=[
        'fornecedor_id',
    'custo_operacional_id',
    'descricao',
    'valor',
    'data_emissao',
    'data_vencimento',
    'data_pagamento',
    'valor_pago',
    'status',
    'forma_pagamento',
    'centro_custo_id',
    'observacoes',
    'lancamento_origem_id'
    ];

         public function fornecedor()
      {
        return $this->belongsTo(Fornecedor::class);
      }

             public function custo_operacional()
      {
        return $this->belongsTo(CustoOperacional::class);
      }

        public function centro_custo()
      {
        return $this->belongsTo(CentroCusto::class);
      }
      public function lancamento()
      {
        return $this->hasMany(LancamentoContabil::class);
      }

      /**
     * Relacionamento com o lançamento de origem
     */
    public function lancamentoOrigem()
    {
        return $this->belongsTo(LancamentoContabil::class, 'lancamento_origem_id');
    }
  
    /**
     * Relacionamento com centro de custo
     */
    public function centroCusto()
    {
        return $this->belongsTo(CentroCusto::class);
    }

    /**
     * Scope para IVA
     */
    public function scopeIva($query)
    {
        return $query->whereNotNull('lancamento_origem_id');
    }

    /**
     * Verificar se é IVA
     */
    public function getIsIvaAttribute()
    {
        return !is_null($this->lancamento_origem_id);
    }
      
}

