<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class ContaReceber extends Model
{
        use HasFactory;
        use SoftDeletes;
    protected $fillable=[

        'cliente_id',
        'frete_id',
        'descricao',
        'valor',
        'data_emissao',
        'data_vencimento',
        'data_pagamento',
        'valor_pago',
        'status',
        'forma_pagamento',
        'categoria',
        'observacoes',
        'outros_devedores',
        'numero_lancamento'


    ];

         public function cliente()
      {
        return $this->belongsTo(Cliente::class);
      }

               public function frete()
      {
        return $this->belongsTo(Frete::class);
      }
      public function lancamento()
      {
        return $this->hasMany(LancamentoContabil::class);
      }

      public function scopePendentes(Builder $query): Builder
{
    return $query->where('status', 'pendente');
}

public function scopePagosMesCorrente(Builder $query): Builder
{
    return $query->where('status', 'pago')
        ->whereMonth('data_pagamento', now()->month)
        ->whereYear('data_pagamento', now()->year);
}

public function scopeListagemPrincipal(Builder $query): Builder
{
    return $query->where(function (Builder $q) {
        $q->pendentes()
          ->orWhere(fn ($sub) => $sub->pagosMesCorrente());
    });
}

protected function getTableQuery(): Builder
    {
        return parent::getTableQuery()
            ->where(function ($query) {
                $query->where('status', 'pendente')
                    ->orWhere(function ($query) {
                        $query->where('status', 'pago')
                            ->whereMonth('data_pagamento', now()->month)
                            ->whereYear('data_pagamento', now()->year);
                    });
            });
    }

    
}
