<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustoOperacional extends Model
{
        use HasFactory;
        use SoftDeletes;
    protected $fillable=[

      'numero_cop',
        'viagem_id',
        'veiculo_id',
        'data',
        'tipo_custo_op_id',
        'descricao',
        'valor',
        'quantidade',
        'unidade',
        'fornecedor_id',
        'numero_documento',
        'forma_pagamento',
        'data_vencimento',
        'status',
        'centro_custo_id'
    ];

         public function viagem()
      {
        return $this->belongsTo(Viagem::class);
      }

           public function veiculo()
      {
        return $this->belongsTo(Viatura::class);
      }

           public function fornecedor()
      {
        return $this->belongsTo(Fornecedor::class);
      }

       public function tipo_custo_op()
      {
        return $this->belongsTo(Tipo_custo_op::class);
      }

       public function centro_custo()
      {
        return $this->belongsTo(CentroCusto::class);
      }

        public function conta_pagar()
      {
        return $this->hasMany(ContaPagar::class);
      }

       public function lancamento()
      {
        return $this->hasMany(LancamentoContabil::class);
      }


}
