<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Factura extends Model
{

use HasFactory;
use SoftDeletes;
    protected $fillable=[
        'cliente_id',
        'numero',
        'data_emissao',
        'data_vencimento',
        'valor_total',
        'valor_pago',
        'status',
    ];

         public function cliente()
      {
        return $this->belongsTo(Cliente::class);
      }

      public function transactions()
      {
        return $this->hasMany(Transaction::class);
      }
      public function lancamento()
      {
        return $this->hasMany(LancamentoContabil::class);
      }

      public function fretes(): BelongsToMany
    {
        return $this->belongsToMany(Frete::class, 'factura_frete')
                    ->withPivot('valor', 'quantidade', 'descricao')
                    ->withTimestamps();
    }


}
