<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Frete extends Model
{
    
    use HasFactory;
use SoftDeletes;
    protected $fillable=[
        'numero_frete',
        'valor_frete',
        'valor_adiantamento',
        'valor_seguro',
        'valor_portagem',
        'valor_outros',
        'valor_liquido',
        'forma_pagamento',
        'parcelas',
        'data_vencimento',
        'status_pagamento'
    ];

    protected $casts = [
        'data_emissao' => 'date',
        'valor_total' => 'decimal:2'
    ];

         public function viagem()
      {
        return $this->hasMany(Viagem::class);
      }

             public function contareceber()
      {
        return $this->belongsTo(ContaReceber::class);
      }

             public function transactions()
      {
        return $this->hasMany(Transaction::class);
      }

      public function lancamento()
      {
        return $this->hasMany(LancamentoContabil::class);
      }

        public function producto()
      {
        return $this->belongsTo(Productos::class);
      }


    // Calcular valor total do frete
    public function calcularValorTotal(): void
    {
        $this->valor_total = $this->cargas()->sum('frete_carga.valor_total');
        $this->saveQuietly();
    }

    public function fretesCargas(): HasMany
{
    return $this->hasMany(FreteCarga::class);
}

// Relação many-to-many tradicional (para consultas, NÃO para o form)
public function cargas(): BelongsToMany
{
    return $this->belongsToMany(Carga::class, 'frete_carga')
                ->using(FreteCarga::class)
                ->withPivot(['quantidade', 'valor_unitario', 'valor_total', 'observacao'])
                ->withTimestamps();
}



}
