<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FreteCarga extends Pivot
{
    protected $table = 'frete_carga';

    public $incrementing = true; // se tiver ID auto-incremento
    public $timestamps = true;   // se desejar created_at/updated_at

    public function frete(): BelongsTo
    {
        return $this->belongsTo(Frete::class);
    }

    public function carga(): BelongsTo
    {
        return $this->belongsTo(Carga::class);
    }

   
}