<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Transaction extends Model
{
    
use HasFactory;
use SoftDeletes;
    protected $fillable=[
        'cliente_id',
        'fornecedor_id',
        'custo_operacional_id',
        'conta_id',
        'frete_id',
        'factura_id',
        'descricao',
        'valor',
        'data_emissao',
        'data_vencimento',
        'data_pagamento',
        'valor_pago',
        'status',
        'forma_pagamento',
        'centro_custo',
        'observacoes'
    ];

         public function cliente()
      {
        return $this->belongsTo(Cliente::class);
      }

         public function frete()
      {
        return $this->belongsTo(Frete::class);
      }

      public function fornecedor()
      {
        return $this->belongsTo(Fornecedor::class);
      }

         public function custo_operacional()
      {
        return $this->belongsTo(CustoOperacional::class);
      }

        public function centro_custo()
      {
        return $this->belongsTo(CentroCusto::class);
      }

    public function facturas()
      {
        return $this->belongsTo(Factura::class);
      }
}
