<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Viagem extends Model
{
        use HasFactory;
    use SoftDeletes;
	
  protected $fillable = [
'origem',
'frete_id',
'numero_viagem',
'destino',
'data_partida',
'd_chegada_prevista',
'd_chegada_real',
'distancia',
'kilometragem_inicial',
'kilometragem_final',
'motorista_id',
'veiculo_id',
'status'
  ];
    
        public function motorista()
      {
        return $this->belongsTo(Driver::class);
      }

      public function veiculo()
      {
        return $this->belongsTo(Viatura::class);
      }

      public function custooperacional()
      {
    
        return $this->hasMany(CustoOperacional::class);
      }

        public function frete()
      {
    
        return $this->belongsTo(Frete::class);
      }
}
