<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Abastecimento;
use Illuminate\Auth\Access\HandlesAuthorization;

class AbastecimentoPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Abastecimento');
    }

    public function view(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('View:Abastecimento');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Abastecimento');
    }

    public function update(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('Update:Abastecimento');
    }

    public function delete(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('Delete:Abastecimento');
    }

    public function restore(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('Restore:Abastecimento');
    }

    public function forceDelete(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('ForceDelete:Abastecimento');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Abastecimento');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Abastecimento');
    }

    public function replicate(AuthUser $authUser, Abastecimento $abastecimento): bool
    {
        return $authUser->can('Replicate:Abastecimento');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Abastecimento');
    }

}