<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Conta;
use Illuminate\Auth\Access\HandlesAuthorization;

class ContaPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Conta');
    }

    public function view(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('View:Conta');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Conta');
    }

    public function update(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('Update:Conta');
    }

    public function delete(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('Delete:Conta');
    }

    public function restore(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('Restore:Conta');
    }

    public function forceDelete(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('ForceDelete:Conta');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Conta');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Conta');
    }

    public function replicate(AuthUser $authUser, Conta $conta): bool
    {
        return $authUser->can('Replicate:Conta');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Conta');
    }

}