<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\CustoOperacional;
use Illuminate\Auth\Access\HandlesAuthorization;

class CustoOperacionalPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:CustoOperacional');
    }

    public function view(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('View:CustoOperacional');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:CustoOperacional');
    }

    public function update(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('Update:CustoOperacional');
    }

    public function delete(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('Delete:CustoOperacional');
    }

    public function restore(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('Restore:CustoOperacional');
    }

    public function forceDelete(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('ForceDelete:CustoOperacional');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:CustoOperacional');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:CustoOperacional');
    }

    public function replicate(AuthUser $authUser, CustoOperacional $custoOperacional): bool
    {
        return $authUser->can('Replicate:CustoOperacional');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:CustoOperacional');
    }

}