<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Frete;
use Illuminate\Auth\Access\HandlesAuthorization;

class FretePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Frete');
    }

    public function view(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('View:Frete');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Frete');
    }

    public function update(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('Update:Frete');
    }

    public function delete(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('Delete:Frete');
    }

    public function restore(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('Restore:Frete');
    }

    public function forceDelete(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('ForceDelete:Frete');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Frete');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Frete');
    }

    public function replicate(AuthUser $authUser, Frete $frete): bool
    {
        return $authUser->can('Replicate:Frete');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Frete');
    }

}