<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Funcionario;
use Illuminate\Auth\Access\HandlesAuthorization;

class FuncionarioPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:Funcionario');
    }

    public function view(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('View:Funcionario');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:Funcionario');
    }

    public function update(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('Update:Funcionario');
    }

    public function delete(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('Delete:Funcionario');
    }

    public function restore(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('Restore:Funcionario');
    }

    public function forceDelete(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('ForceDelete:Funcionario');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:Funcionario');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:Funcionario');
    }

    public function replicate(AuthUser $authUser, Funcionario $funcionario): bool
    {
        return $authUser->can('Replicate:Funcionario');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:Funcionario');
    }

}