<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\Tipo_custo_op;
use Illuminate\Auth\Access\HandlesAuthorization;

class Tipo_custo_opPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:TipoCustoOp');
    }

    public function view(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('View:TipoCustoOp');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:TipoCustoOp');
    }

    public function update(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('Update:TipoCustoOp');
    }

    public function delete(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('Delete:TipoCustoOp');
    }

    public function restore(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('Restore:TipoCustoOp');
    }

    public function forceDelete(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('ForceDelete:TipoCustoOp');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:TipoCustoOp');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:TipoCustoOp');
    }

    public function replicate(AuthUser $authUser, Tipo_custo_op $tipoCustoOp): bool
    {
        return $authUser->can('Replicate:TipoCustoOp');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:TipoCustoOp');
    }

}