<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 100);
            $table->string('bi', 14)->unique();
            $table->string('carta_conducao', 20);
            $table->date('data_nascimento');
            $table->string('local_nascimento', 100);
            $table->string('nacionalidade', 80);
            $table->string('telefone', 20);
            $table->string('email', 100)->nullable();
            $table->string('endereco', 255)->nullable();
            $table->string('codigo');          
            $table->date('validade')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drivers');
    }
};
