<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conta_pagars', function (Blueprint $table) {
            $table->id();
            $table->foreignId('fornecedor_id')->constrained('fornecedors');
            $table->foreignId('custo_operacional_id')->nullable()->constrained('custo_operacionals');
            $table->string('descricao');
            $table->decimal('valor', 15, 2);
            $table->date('data_emissao');
            $table->date('data_vencimento');
            $table->date('data_pagamento')->nullable();
            $table->decimal('valor_pago', 15, 2)->nullable();
            $table->string('status'); // pendente, pago_parcial, pago, atrasado
            $table->string('forma_pagamento');
            $table->string('centro_custo')->constrained('centro_custos'); // combustivel, manutencao, salario, imposto, outros
            $table->text('observacoes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conta_pagars');
    }
};
