<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('facturas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cliente_id')->constrained('clientes');
            $table->string('numero')->unique();
            $table->date('data_emissao');
            $table->date('data_vencimento');
            $table->decimal('valor_total', 15, 2);
            $table->decimal('valor_pago', 15, 2)->default(0);
            $table->enum('status', ['rascunho', 'emitida', 'paga', 'cancelada', 'atrasada']); // rascunho, emitida, paga, cancelada, atrasada
            $table->text('observacoes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('factura_cargas', function (Blueprint $table) {

            $table->foreignId('factura_id')->constrained('facturas');
            $table->foreignId('carga_id')->constrained('cargas');
           
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('facturas');
        Schema::dropIfExists('factura_cargas');
        
    }
};
