<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('manutencaos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('veiculo_id')->constrained('viaturas');
            $table->date('data');
            $table->integer('km_atual');
            $table->string('tipo'); // preventiva, corretiva, pneus, etc
            $table->string('servico');
            $table->text('descricao')->nullable();
            $table->decimal('valor', 15, 2);
            $table->foreignId('fornecedor_id')->nullable()->constrained('fornecedors');
            $table->string('numero_nota')->nullable();
            $table->string('status'); // agendada, em_andamento, concluida, cancelada
            $table->date('proxima_manutencao_km')->nullable();
            $table->date('proxima_manutencao_data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('manutencaos');
    }
};
